﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using rsi.Controls.iToolTip;
using Test.webservice;

///
/// WRITTEN BY FLORIAN RAPPL, 2011
/// CODE IS FREE TO USE -- CPOL [ Code Project Open License ]
/// 

namespace Test
{
    public class SampleDataProvider : IToolTipDataProvider
    {
        #region members

        Timer ws;
        Control userState;
        string request;
        Random ran;

        #endregion

        #region ctor

        public SampleDataProvider()
        {
            ran = new Random();
            ws = new Timer();
            ws.Interval = 2000;
            ws.Tick += new EventHandler(ws_Tick);
        }

        #endregion

        #region IToolTipDataProvider Member

        public object RequestData(string request)
        {
            System.Threading.Thread.Sleep(2000);

            if (ran.NextDouble() < 0.1)
                throw new Exception("A sample exception...");

            return request;
        }

        public void RequestDataAsync(string request, Control userState)
        {
            this.userState = userState;
            this.request = request;
            ws.Start();
        }

        public void CancelDataAsync(Control userState)
        {
            ws.Stop();
        }

        public event ToolTipDataEventHandler RequestDataHandled;

        #endregion

        #region Methods

        void ws_Tick(object sender, EventArgs e)
        {
            Exception ex = null;

            if (ran.NextDouble() < 0.1)
                ex = new Exception("A sample (async) exception...");

            if (RequestDataHandled != null)
                RequestDataHandled(this, new ToolTipDataEventArgs(request, userState, ex));
        }

        #endregion
    }
}
